package gov.va.med.mhv.admin.util;

import java.util.Iterator;
import java.util.Properties;

////import gov.va.med.mhv.usermgmt.util.Precondition;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Null-safe utility for extracting property values from
 * {@link java.util.Properties} instances.
 */
public final class SMPropertiesUtil {

	private static final Log LOG = LogFactory.getLog(SMPropertiesUtil.class);

	public static final String RELOAD_SYSTEM_PROPERTY_NAME =
		"properties.reload";

	public static boolean getReloadProperties() {
	    String property = System.getProperty(RELOAD_SYSTEM_PROPERTY_NAME);
	    boolean value = Boolean.parseBoolean(property);
	    if (LOG.isInfoEnabled()) {
	    	LOG.info("Load properties once");
	    }
	    return value;
	}

	/**
	 * Extract a named int property from the given properties instance.
	 * @param resourceName The name of the resource the properties where loaded
	 * from.
	 * @param properties The properties instance to inspect.
	 * @param name The property name
	 * @param defaultValue The default value, to use if no value found.
	 * @return The value if found; If not found, the properties instance is
	 * null or the value was not a valid int value, the given default value.
	 */
	public static int getIntValue(String resourceName, Properties properties,
		String name, int defaultValue)
	{
		int value = defaultValue;
		if (properties != null) {
			String propertyValue = properties.getProperty(name);
			if (!StringUtils.isBlank(propertyValue)) {
				try {
					value = Integer.parseInt(propertyValue);
				} catch (NumberFormatException e) {
					LOG.warn("Format error in property '" + name);
//					LOG.warn("Format error in property '" + name + "' value '"
//						+ propertyValue + "' from '" + resourceName
//						+ "'. Using default value '" + defaultValue + "'", e);
				}
			}
		} else {
			logMissingProperties(resourceName, name, Integer.toString(
				defaultValue));
		}
		return value;
	}


	/**
	 * Extract a named boolean property from the given properties instance.
	 * @param resourceName The name of the resource the properties where loaded
	 * from.
	 * @param properties The properties instance to inspect.
	 * @param name The property name
	 * @param defaultValue The default value, to use if no value found.
	 * @return The value if found; If not found, the properties instance is
	 * null or the value was not a valid int value, the given default value.
	 */
	public static boolean getBooleanValue(String resourceName,
		Properties properties, String name, boolean defaultValue)
	{
		boolean value = defaultValue;
		if (properties != null) {
			String propertyValue = properties.getProperty(name);
			if (!StringUtils.isBlank(propertyValue)) {
				try {
					value = Boolean.parseBoolean(propertyValue);
				} catch (NumberFormatException e) {
					LOG.warn("Format error in property.");
				}
			}
		} else {
			logMissingProperties(resourceName, name, Boolean.toString(
				defaultValue));
		}
		return value;
	}

	/**
	 * Extract a named String property from the given properties instance.
	 * @param resourceName The name of the resource the properties where loaded
	 * from.
	 * @param properties The properties instance to inspect.
	 * @param name The property name
	 * @param defaultValue The default value, to use if no value found.
	 * @return The value if found; If not found or the properties instance is
	 * null, the given default value.
	 */
	public static String getValue(String resourceName, Properties properties,
		String name, String defaultValue)
	{
		String value = defaultValue;
		if (properties != null) {
			value = properties.getProperty(name, defaultValue);
		} else {
			logMissingProperties(resourceName, name, defaultValue);
		}
		return value;
	}

	/**
	 * Extract a named String property from the given properties instance.
	 * @param resourceName The name of the resource the properties where loaded
	 * from.
	 * @param properties The properties instance to inspect.
	 * @param name The property name
	 * @param defaultValue The default value, to use if no value found.
	 * @return The value if found; If not found or the properties instance is
	 * null, the given default value.
	 */
	public static String getValueIgnoreCase(String resourceName,
		Properties properties, String name, String defaultValue)
	{
		////Precondition.assertNotBlank("name", name);
		String value = defaultValue;
		if ((properties != null)){
			boolean found = false;
			for (Iterator i = properties.keySet().iterator();
			     (!found) && i.hasNext();)
			{
				String key = (String) i.next();
				found = (name.equalsIgnoreCase(key));
				if (found) {
					value = getValue(resourceName, properties, name,
						defaultValue);
				}
			}
		} else {
			logMissingProperties(resourceName, name, defaultValue);
		}
		return value;
	}


	private static void logMissingProperties(String resourceName, String name,
		String defaultValue)
	{
		// had to change to static text for fortify resolution
		LOG.info("Property not found. Using default value");
	}


	private SMPropertiesUtil() {
		// Hide constructor because utility class
		super();
	}



}
